<?php
include "../../conn.php";

// Create bet_rebates table
$createTableQuery = "CREATE TABLE IF NOT EXISTS bet_rebates (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    bet_id INT NOT NULL,
    game_table VARCHAR(50) NOT NULL,
    bet_amount DECIMAL(10,2) NOT NULL,
    rebate_rate DECIMAL(5,4) NOT NULL,
    rebate_amount DECIMAL(10,2) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_user_id (user_id),
    INDEX idx_created_at (created_at),
    INDEX idx_game_table (game_table),
    UNIQUE KEY unique_bet_rebate (user_id, bet_id, game_table)
)";

if ($conn->query($createTableQuery)) {
    echo "bet_rebates table created successfully\n";
} else {
    echo "Error creating bet_rebates table: " . $conn->error . "\n";
}

// Test the table
$testQuery = "SHOW TABLES LIKE 'bet_rebates'";
$result = $conn->query($testQuery);
if ($result->num_rows > 0) {
    echo "bet_rebates table exists\n";
    
    // Show table structure
    $descQuery = "DESCRIBE bet_rebates";
    $descResult = $conn->query($descQuery);
    echo "Table structure:\n";
    while ($row = $descResult->fetch_assoc()) {
        echo "- " . $row['Field'] . " (" . $row['Type'] . ")\n";
    }
} else {
    echo "bet_rebates table does not exist\n";
}
?>
